/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.model.functional;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.client.model.BedrockGunModel;
import com.tacz.guns.client.model.IFunctionalRenderer;
import com.tacz.guns.client.model.SlotModel;
import com.tacz.guns.client.model.bedrock.BedrockModel;
import com.tacz.guns.client.resource.pojo.display.gun.MuzzleFlash;
import com.tacz.guns.compat.iris.IrisCompat;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class MuzzleFlashRender
implements IFunctionalRenderer {
    private static final SlotModel MUZZLE_FLASH_MODEL = new SlotModel(true);
    private static final long TIME_RANGE = 50L;
    public static boolean isSelf = false;
    private static long shootTimeStamp = -1L;
    private static boolean muzzleFlashStartMark = false;
    private static float muzzleFlashRandomRotate = 0.0f;
    private static Matrix3f muzzleFlashNormal = new Matrix3f();
    private static Matrix4f muzzleFlashPose = new Matrix4f();
    private final BedrockGunModel bedrockGunModel;

    public MuzzleFlashRender(BedrockGunModel bedrockGunModel) {
        this.bedrockGunModel = bedrockGunModel;
    }

    public static void onShoot() {
        shootTimeStamp = System.currentTimeMillis();
        muzzleFlashStartMark = true;
        muzzleFlashRandomRotate = (float)(Math.random() * 360.0);
    }

    private static void renderMuzzleFlash(class_2960 gunId, class_4587 matrixStack, BedrockModel bedrockModel, long time) {
        TimelessAPI.getClientGunIndex(gunId).ifPresent(gunIndex -> {
            MuzzleFlash muzzleFlash = gunIndex.getMuzzleFlash();
            if (muzzleFlash == null) {
                return;
            }
            if (muzzleFlashStartMark) {
                muzzleFlashNormal = new Matrix3f((Matrix3fc)matrixStack.method_23760().method_23762());
                muzzleFlashPose = new Matrix4f((Matrix4fc)matrixStack.method_23760().method_23761());
            }
            bedrockModel.delegateRender((poseStack1, vertexConsumer1, transformType1, light, overlay) -> MuzzleFlashRender.doRender(light, overlay, muzzleFlash, time));
        });
    }

    private static void doRender(int light, int overlay, MuzzleFlash muzzleFlash, long time) {
        if (muzzleFlashNormal != null && muzzleFlashPose != null) {
            float scale = 0.5f * muzzleFlash.getScale();
            float scaleTime = 25.0f;
            scale = (float)time < scaleTime ? scale * ((float)time / scaleTime) : scale;
            muzzleFlashStartMark = false;
            class_4597.class_4598 multiBufferSource = class_310.method_1551().method_22940().method_23000();
            class_4587 poseStack2 = new class_4587();
            poseStack2.method_23760().method_23762().mul((Matrix3fc)muzzleFlashNormal);
            poseStack2.method_23760().method_23761().mul((Matrix4fc)muzzleFlashPose);
            poseStack2.method_22903();
            poseStack2.method_22905(scale, scale, scale);
            poseStack2.method_22907(class_7833.field_40718.rotationDegrees(muzzleFlashRandomRotate));
            poseStack2.method_46416(0.0f, -1.0f, 0.0f);
            class_1921 renderTypeBg = class_1921.method_23580((class_2960)muzzleFlash.getTexture());
            MUZZLE_FLASH_MODEL.method_2828(poseStack2, multiBufferSource.getBuffer(renderTypeBg), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack2.method_22909();
            poseStack2.method_22903();
            poseStack2.method_22905(scale / 2.0f, scale / 2.0f, scale / 2.0f);
            poseStack2.method_22907(class_7833.field_40718.rotationDegrees(muzzleFlashRandomRotate));
            poseStack2.method_22904(0.0, -0.9, 0.0);
            class_1921 renderTypeLight = class_1921.method_23018((class_2960)muzzleFlash.getTexture(), (float)1.0f, (float)1.0f);
            MUZZLE_FLASH_MODEL.method_2828(poseStack2, multiBufferSource.getBuffer(renderTypeLight), light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack2.method_22909();
        }
    }

    @Override
    public void render(class_4587 poseStack, class_4588 vertexBuffer, class_811 transformType, int light, int overlay) {
        if (IrisCompat.isRenderShadow()) {
            return;
        }
        if (!isSelf) {
            return;
        }
        long time = System.currentTimeMillis() - shootTimeStamp;
        if (time > 50L) {
            return;
        }
        class_1799 currentGunItem = this.bedrockGunModel.getCurrentGunItem();
        IGun iGun = IGun.getIGunOrNull(currentGunItem);
        if (iGun == null) {
            return;
        }
        class_2960 gunId = iGun.getGunId(currentGunItem);
        class_1799 muzzleAttachment = this.bedrockGunModel.getCurrentAttachmentItem().get((Object)AttachmentType.MUZZLE);
        IAttachment iAttachment = IAttachment.getIAttachmentOrNull(muzzleAttachment);
        if (iAttachment != null) {
            TimelessAPI.getCommonAttachmentIndex(iAttachment.getAttachmentId(muzzleAttachment)).ifPresent(index -> {
                if (index.getData().getSilence() != null) {
                    return;
                }
                MuzzleFlashRender.renderMuzzleFlash(gunId, poseStack, this.bedrockGunModel, time);
            });
        } else {
            MuzzleFlashRender.renderMuzzleFlash(gunId, poseStack, this.bedrockGunModel, time);
        }
    }
}

